/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;

public class BlockLucisMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape V_SHAPE = BlockLucisMushroom.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BNBlockProperties.EnumLucisShape> SHAPE = BNBlockProperties.LUCIS_SHAPE;

    public BlockLucisMushroom() {
        super(BehaviourBuilders.createWalkablePlant((MapColor)MapColor.f_283832_).m_60953_(bs -> 15).m_60999_().m_60918_(SoundType.f_56736_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)BNBlockProperties.EnumLucisShape.CORNER)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING, SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return V_SHAPE;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.LUCIS_SPORE), new ItemStack((ItemLike)NetherItems.GLOWSTONE_PILE, MHelper.randRange(2, 4, MHelper.RANDOM))});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            if (state.m_61143_(SHAPE) == BNBlockProperties.EnumLucisShape.SIDE) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122428_());
            }
            if (state.m_61143_((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.m_61143_((Property)FACING) == Direction.WEST) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.m_61143_((Property)FACING) == Direction.EAST) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.SOUTH);
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (state.m_61143_(SHAPE) == BNBlockProperties.EnumLucisShape.SIDE) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122428_());
            }
            if (state.m_61143_((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.m_61143_((Property)FACING) == Direction.EAST) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.m_61143_((Property)FACING) == Direction.WEST) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.SOUTH);
            }
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.LUCIS_SPORE);
    }
}

